<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Facilities extends MY_Controller {

	public function __construct() {
		parent::__construct();
		$currency = '';

		$this->$currency =  GeneralSettings();

	}

	public function index(){

		$currency = '';

		if ($this->session->userdata('logged_in') == 1) {
			$response = getUserDetails();
			$data['userDetails'] = $response->data[0];
		}

		$data['GetState'] = GetState();
		$data['preferredLanguage'] = getPreferredLanguage();



		$data['currency'] = $this->$currency;
		$data['page'] = 'Facilities';
		$data['title'] = 'Facilities';
		$this->load->view('facilities/facilities',$data);	
	}


	
	public function getcityByState(){
		$stateName = $this->input->post('stateCode');
		return GetCity($stateName);
	}

	

	public function addCart(){

		if($this->input->post())
		{
			$this->session->set_userdata('facilities_cart', $this->input->post());
		}
		$response = array('status' => '1', 'message' => "Success");
		echo json_encode($response);	
	}




	public function BookFacilities(){


		if ($this->session->userdata('logged_in') == 1) {
			$facilities_shift = SettingsApi()['result']['data'][0]['facilitySettings']['shift'];


			$eventDetails = $this->session->userdata('event_details');

			$cart_data = $this->session->userdata('facilities_cart');
	
			$facilitiesData = array();

			for ($i = 0; $i < count($cart_data['ids']); $i++) {

				$startTime = '';
				$endTime = '';
				foreach ($facilities_shift as $shift) {


					if ($shift['name'] === @$cart_data['bookingTypes'][$i]) {
						$startTime = @$shift['startTime'];
						$endTime = @$shift['endTime'];
						// Break the loop once matching shift is found
						break;
					}else{
						$startTime =  @$cart_data['start_time'][$i];
						$endTime  = @$cart_data['end_time'][$i];
					}
				}



				$discounted_price = 0;
				$payNowTotalAmount = 0;
				$userDetails = getUserDetails()->data[0];

				if (@$userDetails->isMember == 1 && @$userDetails->membershipStatus == 'ACTIVE' && @$cart_data['is_membership_discount'][$i] == 'YES') {

					$setting =  SettingsApi();
					$membershipDiscount = $setting['result']['data'][0]['membershipSettings']['membershipDiscount'];
					$discountType = $setting['result']['data'][0]['membershipSettings']['discountType'];

					if ($discountType == 'FLAT') {

						if ($cart_data['serviceAmount'][$i] > $membershipDiscount) {

							$discounted_price = $cart_data['serviceAmount'][$i] - $membershipDiscount;

						}

					}else{

						$discounted_price = $cart_data['serviceAmount'][$i] - ($cart_data['serviceAmount'][$i] * $membershipDiscount) / 100;

					}
				}



				$final_price = $discounted_price > 0 ? $discounted_price : $cart_data['serviceAmount'][$i]; 


				$payNowTotalAmount += $final_price;




				$facilitiesData[] = array(
					"_id" => $cart_data['ids'][$i],
					"ServiceId" => $cart_data['ids'][$i],
					"serviceName" => $cart_data['serviceName'][$i],
					"serviceCategory" => $cart_data['ctg'][$i],
					"serviceType" => $cart_data['serviceTypes'][$i],
					"serviceAmount" => $final_price,
					"costPerDay" => $final_price,
					"startDate" => @$cart_data['startDate'][$i],
					"qty" => $cart_data['qty'][$i],
					"time" => @$cart_data['startTime'][$i],
					"day" => "",
					"bookingTypes" => @$cart_data['bookingTypes'][$i],
					"startTime" => @$startTime,
					"endTime" => @$endTime
				);
			}


			// print_r($facilitiesData); 

			$facilitiesData = json_encode($facilitiesData);

			$ch = curl_init();

			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

			curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'].addRentalServiceCart()['url']);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_POST, 1);

			curl_setopt($ch, CURLOPT_POSTFIELDS, "{

				\"productId\":\"".ApiBaseUrl()['productID']."\",
				\"clientId\":\"".ApiBaseUrl()['clientID']."\",
				\"memberId\":\"".$this->session->userdata('id')."\",
				\"memberName\":\"".$this->session->userdata('refDataName')."\",
				\"prsnEmail\":\"".$this->session->userdata('email')."\",
				\"prsnPhone\":\"".$this->session->userdata('phone')."\",
				\"eventDetail\":".json_encode($eventDetails).",
				\"deliveryDetails\":{},
				\"deliveryTime\":\"\",
				\"paymentType\":\"PENDING\",
				\"deliveryDate\":\"\",
				\"delivery\":\"\",
				\"etKitchenTIp\":\"\",
				\"pickupTime\":\"\",
				\"bankName\":\"\",
				\"chequeNo\":\"\",
				\"chequeAmount\":\"\",
				\"chequeDate\":\"\",
				\"source\":\"WEBSITE\",
				\"totalAmount\": ".$payNowTotalAmount.",
				\"transactionId\":\"\",
				\"stationName\":\"\",
				\"stationId\":\"\",
				\"userId\":\"".$this->session->userdata('refDataName')."\",
				\"data\":$facilitiesData

			}");	



			$headers = array();
			$headers[] = 'Content-Type: application/json';
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

			$result = curl_exec($ch);
			if (curl_errno($ch)) {
				echo 'Error:' . curl_error($ch);
			}
			curl_close($ch);

			$response = json_decode($result);
			if ($response->statusCode == 1) {
				$this->session->unset_userdata('facilities_cart');
				echo json_encode($response);
			}
		}
	}

	public function ViewCart(){
		$currency = '';
		$data['currency'] = $this->$currency;
		$data['page'] = 'Facilities';
		$data['title'] = 'Facilities Cart';
		$data['session_data'] = 'facilities_cart';
		$this->load->view('facilities/view-cart',$data);
	}

	public function delete_cart_row(){
		$row_id = $this->input->post('row_id');
		$cart_items = $this->session->userdata('facilities_cart');
		$total_price = $cart_items['totalPrice'];
		$row_price = 0;
		foreach($cart_items['ids'] as $key => $id){
			if($id == $row_id){
            // remove the row from the cart data
				$row_price = $cart_items['serviceAmount'][$key];
				unset($cart_items['ids'][$key]);
				unset($cart_items['serviceName'][$key]);
				unset($cart_items['description'][$key]);
				unset($cart_items['serviceAmount'][$key]);
				unset($cart_items['qty'][$key]);
				unset($cart_items['image'][$key]);
				break;
			}
		}
    // subtract the row amount from the total amount
		$total_price -= $row_price;
    // update the total price in the cart data
		$cart_items['totalPrice'] = $total_price;
    // save the updated cart data to session
		$this->session->set_userdata('facilities_cart', $cart_items);
    // send response to the client
		echo json_encode(array('status' => 'success'));
	}

	public function getShiftTimings(){
		$shift = $this->input->post('shift');

		$facilities_shift = SettingsApi()['result']['data'][0]['facilitySettings']['shift'];

		foreach ($facilities_shift as $item) {

			if ($item['name'] == $shift) {
				$startTime = $item['startTime'];
				$endTime = $item['endTime'];
						// Break the loop once matching shift is found
				break;
			}else{
				$startTime =  '';
				$endTime  = '';
			}
		}


		$timings = array('startTime' => $startTime, 'endTime' => $endTime);


		echo json_encode($timings);


	}


	public function SubmitEventForm() {
		$postData = $this->input->post(); 

		$eventDetails = array();
		$eventDetails['eventName'] = $postData['eventName'];
		$eventDetails['eventDate'] = $postData['eventDate'];
		$eventDetails['eventTime'] = $postData['eventTime'];
		$eventDetails['eventEndTime'] = $postData['eventEndTime'];
		$eventDetails['eventAddress'] = $postData['eventLocation']; 
		$eventDetails['eventCity'] = $postData['city'];
		$eventDetails['eventState'] = $postData['state'];
		$eventDetails['eventLanguage'] = @$postData['preferredLanguage'];
		$eventDetails['adults'] = $postData['adults'];
		$eventDetails['children'] = $postData['children'];
		$eventDetails['zip'] = $postData['zipcode'];
		$eventDetails['eventDescription'] = $postData['eventDescription'];

    // Set session data
		$this->session->set_userdata('event_details', $eventDetails);

    // Return a response
		$response = array(
			'success' => 1,
			'message' => 'Event details saved successfully.'
		);
		echo json_encode($response);
	}

}