<?php $this->load->view('admin/includes/head'); ?>
<?php $this->load->view('admin/includes/sidebar'); ?>
<?php $this->load->view('admin/includes/topbar'); ?>
<!-- Main content-->
<div class="container px-2 mt-4">	
	<?php 

	$success = $this->session->flashdata('success'); 
	$failure = $this->session->flashdata('failure'); 

	echo $success ?  $success :  $failure ;

	?>
	<div class="table-responsive">
		<table id="myDonations" class="table table-hovered">
			<thead style="background-color: var(--devotee-table-header-bg); color: white;width: 100%;">
				<tr>
					<th class="text-center">Token #</th>
					<th class="text-center">Service Name</th>
					<th class="text-center">Service Date</th>
					<th class="text-center">Total Amount</th>
					<th class="text-center">Payment Type</th>
					<th class="text-center">Payment Source</th>
					<th class="text-center">Initiated Date</th>
					<th class="text-center">Status</th>
					<th class="text-center">Refund Payment</th>
					<th class="text-center">View Receipt</th>
				</tr>
			</thead>
			<tbody style="width:100%">
				<?php  foreach($payments_data as $val){ 

					$serviceDate = @$val->paymentsData[0]->serviceDate;
					$serviceDateTime = DateTime::createFromFormat('m/d/Y', $serviceDate);
					$currentDateTime = new DateTime();

					if ($serviceDateTime < $currentDateTime) {
						$refund_btn = '';
					}else{
						$refund_btn = '<a href="'.base_url('admin/refund-payment/'.base64_encode($val->_id)).'" class="btn btn-sm text-center btn-warning">Refund Request</a>';
					}
					?>


					<?php if($val->paymentStatus != 'TEMP'){  ?>
						<tr>
							<td class="text-center"><?=$val->batchNo;?></td>
							<!-- <td class="text-center"><?=$val->transactionId;?></td> -->
							<td class="text-center"><?=camelCase(@$val->paymentsData[0]->ServiceSetup);?></td>
							<td class="text-center"><?= @$val->paymentsData[0]->serviceDate; ?></td>
							<td class="text-center" style="text-align: right;padding-right: 21px"><?= '$'.sprintf("%.2f",$val->totalAmount);?></td>
							<td class="text-center"><?=camelCase($val->paymentType);?></td>
							<td class="text-center"><?=camelCase($val->source);?></td>
							<td class="text-center"><?=$val->recCreDate;?></td>

							<td class="text-center" >
								<?php
								echo $val->paymentStatus == 'COMPLETED' ? '<span class="badge">'.$val->paymentStatus.'</span>' : '<span style="background:#FAA21B!important;color:#FFFFFF!important;text-shadow:1px 0px 0px black" class="badge" >'.$val->paymentStatus.'</span>' ;
								?>
							</td>
							<td class="text-center"><?=$refund_btn;?></td>
							<td class="text-center" class="text-center"><a href="<?=base_url('admin/download-reciept/'.base64_encode($val->tokenNumber).'/PAYMENTS')?>" target="_blank"><i class="fa fa-eye" style="font-size:22px"></i></a></td>
						</tr>
					<?php }} ?>
				</tbody>
			</table>
		</div>

	</div>
	<!-- End Main content--> 
	<script>

		$(document).ready(function() {
			$("#heading").text('My Payments');
			$('#myDonations').DataTable( {
				order: [[ 0, 'desc' ]],
				"lengthChange": false,
				"scrollX": true,
				"ordering": false,
				"searching": true,
				language: {
					emptyTable: "No Payments Available to show..",
					search: ''
				}
			} );
		} );
		
	</script>
</body>
</html>
