<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends MY_Controller {

	public function __construct() {
		parent::__construct();

		$currency = '';

		$this->$currency =  GeneralSettings();

	}


	public function index()
	{

		$data['page'] = 'Home';
		$banner = getWebSyncsData('Banner Images', 'bannerImages', 'ACTIVE');
		$data['slider_image'] = sortBySequenceId($banner);

		$filter['query'] = ['aspectType'=>'ServiceSetup','serviceCategoryTypes'=>'EVENTS', 'sourceTypes' => 'WEBSITE', 'status' => 'ACTIVE', '$expr' => ['$eq' => ['$parentService', '']]];


		$data['upcoming_events'] = sortBySequenceId(getServiceRequestData($filter));

		$this->load->view('home',$data);
	}


	public function getpanchangamData(){
		$lat = $this->input->post('lat');
		$long = $this->input->post('long');
		$tzone = $this->input->post('tzone');

		$year = date('Y');
		$month = date('m');
		$day = date('d');
		$hours = date('H');
		$minute = date('i');

		$panchangam = getPanchangamData($lat, $long, $tzone, $year, $month, $day, $hours, $minute);

		
		$panchangam = json_decode(json_encode($panchangam), true);
		
		$html = '';
		$html .= '<div class="table-responsive">
		<table class="table table-responsive table-bordered table-striped" style="border-collapse: collapse;min-height:420px">
		<tbody>
		<tr style="text-align: center; border: 2px solid #642318;border-top: 1px solid #642318;">
		<td>Date</td>
		<td>'.date('m/d/Y').'</td>
		</tr>
		<tr style="text-align: center; border: 2px solid #642318;border-top: 1px solid #642318;">
		<td>Day</td>
		<td>'.$panchangam['day'].'</td>
		<tr>
		<tr style="text-align: center; border: 2px solid #642318;border-top: 1px solid #642318;">
		<td>Tithi</td>
		<td>'.$panchangam['tithi'].'</td>
		</tr>
		<tr style="text-align: center; border: 2px solid #642318;border-top: 1px solid #642318;">
		<td>Nakshatra</td>
		<td>'.$panchangam['nakshatra'].'</td>
		</tr>
		<tr style="text-align: center; border: 2px solid #642318;border-top: 1px solid #642318;">
		<td>Yog</td>
		<td>'.$panchangam['yog'].'</td>
		</tr>
		<tr style="text-align: center; border: 2px solid #642318;border-top: 1px solid #642318;">
		<td>Karan</td>
		<td>'.$panchangam['karan'].'</td>
		</tr>
		<tr style="text-align: center; border: 2px solid #642318;border-top: 1px solid #642318;">
		<td>Sunrise</td>
		<td>'.$panchangam['sunrise'].'</td>
		</tr>
		<tr style="text-align: center; border: 2px solid #642318;border-top: 1px solid #642318;">
		<td>Sunset</td>
		<td>'.$panchangam['sunset'].'</td>
		</tr>
		<tr style="text-align: center; border: 2px solid #642318;border-top: 1px solid #642318;">
		<td>Vedic Sunrise</td>
		<td>'.$panchangam['vedic_sunrise'].'</td>
		</tr>
		<tr style="text-align: center; border: 2px solid #642318;border-top: 1px solid #642318;">
		<td>Vedic Sunset</td>
		<td>'.$panchangam['vedic_sunset'].'</td>
		</tr>
		</tbody>
		</table>
		</div>


		';
		echo json_encode($html);

	}

	public function Calendar()
	{
		$data['title'] = 'Calendar';
		$data['page'] = 'Calendar';
		$data['calendar_events'] = getWebSyncsData('Temple Calendar', 'templeCalendar', '');
		$data['religious_data']=json_decode(json_encode(Religious()->data), true);
		// echo '<pre>';
		// print_r($data['religious_data']);die;
		$this->load->view('calendar', $data);
	}

	public function NewsLetter(){

		$data['title'] = 'Newsletter';
		$data['page'] = 'Newsletter';


		$ch = curl_init();
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

		curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'].filterAPI()['url']);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);

		$request = array(
			"componentConfig" => array(
				"moduleName" => "Templates",
				"productID" => ApiBaseUrl()['productID'],
				"clientID" => ApiBaseUrl()['clientID'],
				"aspectType" => "templates",
				"query" => array("aspectType" => "templates"),
				"userName" => "",
				"skip" => 0,
				"next" => 1020
			)
		);

		$json_data = json_encode($request);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $json_data);
		$headers = array();
		$headers[] = 'Content-Type: application/json';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);
		$data['newsletter'] = json_decode($result, true);


		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}

		curl_close($ch);

		$this->load->view('newsletter', $data);
	}

	public function Gallery()
	{
		$data['page'] = 'Gallery';
		$data['title'] = 'Gallery';
		$data['gallery_data'] = getWebSyncsData('Gallery Settings', 'gallerySettings', '');
		$this->load->view('gallery',$data);
	}

	public function FilterGalleryBy($refDataname,$id)
	{
		$data['page'] = 'Gallery';
		$res = getWebSyncsData('Gallery Settings', 'gallerySettings', '');
		foreach($res as $item){
			if ($item['_id'] == $id) {

				$data['parent_data'] = $item['Parent'];
				$data['Child_Grid'] = $item['Child Grid'];
			}
		}

		$this->load->view('filtered-gallery',$data);
	}


	


	
	public function getServiceDetailsById()
	{
		$this->session->unset_userdata('serviceDetails');

		$serviceId = $this->input->post('serviceId');
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

		curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'].getServiceDetailbyId()['url']);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, "{          
			\"_id\": \"".$serviceId."\",          
			\"productId\":\" ".ApiBaseUrl()['productID']."\",           
			\"clientId\": \"".ApiBaseUrl()['clientID']."\",           
			\"username\":\"asdf\"        
		}");

		$headers = array();
		$headers[] = 'Content-Type: application/json';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);

		$response = json_decode($result);
		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}
		$serviceDeails = json_decode(json_encode($response->data[0]), true);

		echo json_encode($serviceDeails);
	}





	public function checkLoginStatus(){
		if ($this->session->userdata('logged_in') == 1) {
			echo json_encode(1);
		}else{
			echo json_encode(0);
		}
	}



	public function SignUp(){

		if (!empty($this->input->post('fname')) || !empty($this->input->post('email')) || !empty($this->input->post('email'))) {
			$fname = $this->input->post('fname');
			$lname = $this->input->post('lname');
			$email = $this->input->post('email');
			$phone = $this->input->post('phone');
			$phone = preg_replace('/[^\d]/', '', $phone);
			$countryCode = $this->input->post('countryCode');
			$data=array('refDataName'=>$fname.' '.$lname,'email'=>$email,'phone'=>$phone, 'contryCode'=>$countryCode);







			$postfield=json_encode($data);

			$ch = curl_init();
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

			curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'].customerSignup()['url']);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"dataJson\": $postfield,
				\n      \"componentConfig\": {\n        \"moduleName\": \"".customerSignup()['moduleName']."\",\n        \"productID\": \"".ApiBaseUrl()['productID']."\",\n        \"clientID\": \"".ApiBaseUrl()['clientID']."\"\n    }}");

			$headers = array();
			$headers[] = 'Content-Type:application/json';
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

			$result = curl_exec($ch);

			if (curl_errno($ch)) {
				echo 'Error:' . curl_error($ch);
			}
			curl_close($ch);
			echo json_encode($result);

		}else {
			echo 'Something Went Wrong!!';
		}

	}


	public function Login(){


		if (!empty($this->input->post('email')) || !empty($this->input->post('phone'))) {


			$email = $this->input->post('email');
			$phone = $this->input->post('phone');


			$phone = preg_replace('/[^\d]/', '', $phone);




			$LoginTabName = $this->input->post('LoginTabName');


			if ($LoginTabName == 'Management') {
				$moduleName = 'Management Directory';
			}else{
				$moduleName = customerLogin()['moduleName'];
			}

			if(!empty($email))
			{
				$data=array('email'=>$email,'isMobile'=>false,'phone'=>$phone);
			}
			else
			{
				$data=array('email'=>$email,'isMobile'=>true,'phone'=>$phone);
			}

			$postfield=json_encode($data);


			$ch = curl_init();
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

			curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'].customerLogin()['url']);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"dataJson\": $postfield,
				\n      \"componentConfig\": {\n        \"moduleName\": \"".$moduleName."\",\n        \"productID\": \"".ApiBaseUrl()['productID']."\",\n        \"clientID\": \"".ApiBaseUrl()['clientID']."\"\n    }}");
			$headers = array();
			$headers[] = 'Content-Type:application/json';
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
			// // Add these lines before executing the cURL request
			// 	$request = curl_getinfo($ch, CURLINFO_HEADER_OUT);
			// 	echo "Request: ".$request;
			$result = curl_exec($ch);
			$response = json_decode($result);
			// // Add these lines after getting the response
			// 	echo "Response: ";
			// 	print_r($result);




			if (curl_errno($ch)) {
				echo 'Error:' . curl_error($ch);
			}
			

			// print_r($response);
			if ($response->statusCode == 1) {
				if($email!="" || $this->input->post('sessionCreate') == 1){

					
					if ($moduleName == 'Management Directory') {

						$logged_in_sess = array(
							'id'           => $response->data[0]->_id,
							'refDataName'         => $response->data[0]->refDataName,
							'email'         => $response->data[0]->email,
							'phone'       => $response->data[0]->phone,
							'logged_in'    => 1,
							'token' => $response->data[0]->token,
							'memberTypes' => @$response->data[0]->memberTypes,
							'address' => @$response->data[0]->address,
							'userType' => 'Managements'

						);

					}else{

						$logged_in_sess = array(
							'id'           => $response->data[0]->_id,
							'refDataName'         => $response->data[0]->refDataName,
							'email'         => $response->data[0]->email,
							'phone'       => $response->data[0]->phone,
							'logged_in'    => 1,
							'token' => $response->data[0]->token,
							'memberTypes' => $response->data[0]->memberTypes,
							'address' => @$response->data[0]->address,
							'userType' => 'Devotee'

						);
					}
					$this->session->set_userdata($logged_in_sess);
				}

				
				echo json_encode($response);



			}else{
				echo json_encode('User not found!!');
			}

		}else {
			echo json_encode('Something Went Wrong!!');
		}
	}



	public function sendEmailOTP()
	{



		$email = $this->input->post('email'); 


		$data=array('email'=>$email,'isMobile'=>false,'phone'=>'');



		$postfield=json_encode($data);

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

		curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'].customerLogin()['url']);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"dataJson\": $postfield,
			\n      \"componentConfig\": {\n        \"moduleName\": \"".customerLogin()['moduleName']."\",\n        \"productID\": \"".ApiBaseUrl()['productID']."\",\n        \"clientID\": \"".ApiBaseUrl()['clientID']."\"\n    }}");
		$headers = array();
		$headers[] = 'Content-Type:application/json';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		$result = curl_exec($ch);
		$response = json_decode($result);




		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}

			// $response->statusCode == 1;
		if ($response->statusCode == 1) {
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
			curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'].sendEmailOTP()['url']);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"emailID\":\"".$email."\",\"clientID\":\"".ApiBaseUrl()['clientID']."\"}");

			$headers = array();
			$headers[] = 'Content-Type: application/json';
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

			$result = curl_exec($ch);
			$response = json_decode($result);
			if (curl_errno($ch)) {
				echo 'Error:' . curl_error($ch);
			}
			curl_close($ch);




			

			if($response->user->statusCode==0)
			{
				$response->user->statusCode = '2';
			}

			echo json_encode($response->user);
		}
		else
		{
			echo json_encode($response);
		}



		/*--------------------------*/




	}

	public function verifyEmailOTP(){

		$otp = $this->input->post('otp');
		$email = $this->input->post('email');

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'].verifyEmailOTP()['url']);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"emailID\":\"".$email."\",\"code\":\"".$otp."\"}");

		$headers = array();
		$headers[] = 'Content-Type: application/json';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);
		$response = json_decode($result);
		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}
		curl_close($ch);
		echo json_encode($response->user);

	}




	///MOBILE NUMBER AUTH
	public function sendMobileOTP()
	{
		$phone = $this->input->post('phone'); 
		$ch = curl_init();

		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'].sendEmailOTP()['url']);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"emailID\": \"".$phone."\"}");

		$headers = array();
		$headers[] = 'Content-Type: application/json';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);
		$response = json_decode($result);
		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}
		curl_close($ch);


		echo json_encode($response->user);
	}



	public function addServiceCart(){
		//Post data
		$email 			= 			$this->input->post('email');
		$fname 			= 			$this->input->post('fname');
		$lname 			= 			$this->input->post('lname');
		$fullPackage 			= 			$this->input->post('fullPackage');
		$transactionId 	= 			$this->input->post('transaction_id');
		$serviceAmount 	= 			$this->input->post('serviceAmount');
		$totalAmount 	= 			$this->input->post('serviceAmount');

		$service_Id 	= 			$this->input->post('service_Id');
		$service_name 	= 			$this->input->post('serviceName');

		$serviceCategoryTypes 	= 			$this->input->post('serviceCategoryTypes');
		$serviceTypes 	= 			$this->input->post('serviceTypes');

		$start_date 	= 			$this->input->post('startDate');
		$qty 			= 			$this->input->post('qty');
		$time 			= 			$this->input->post('startTime');
		$day 			= 			$this->input->post('dayTypes');

		$serviceAddress 			= 			$this->input->post('serviceAddress');

		$ch = curl_init();

		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'].addServiceCart()['url']);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, "{         
			\"productId\": \"".ApiBaseUrl()['productID']."\",
			\"clientId\": \"".ApiBaseUrl()['clientID']."\",      
			\"memberId\":\"".$this->session->userdata('id')."\",      
			\"memberName\":\"".$this->session->userdata('refDataName')."\",      
			\"prsnEmail\": \"".$this->session->userdata('email')."\",      
			\"prsnPhone\": \"".$this->session->userdata('phone')."\", 

			\"data\": [{              
				\"_id\": \"".$service_Id."\", 
				\"serviceName\": \"".$service_name."\", 
				\"fullPackage\": \"".$fullPackage."\", 
				\"serviceCategory\": \"".$serviceCategoryTypes."\", 
				\"serviceType\": \"".$serviceTypes."\", 
				\"serviceAmount\": ".$serviceAmount.", 
				\"startDate\":\"".$start_date."\" , 
				\"qty\": ".$qty.", 
				\"time\": \"".$time."\", 
				\"day\":\"".$day."\" , 
				\"serviceAddress\":\"".$serviceAddress."\"  
				}], 

				\"paymentType\": \"CREDIT CARD\", 
				\"bankName\":\"\" ,
				\"chequeNo\":\"\" , 
				\"chequeAmount\":\"\" , 
				\"chequeDate\": \"\", 
				\"totalAmount\": ".$totalAmount.", 
				\"transactionId\":\"".$transactionId."\",
				\"source\":\"WEBSITE\",
				\"stationName\":\"WEBSITE\",
				\"userId\":\"\",
				\"stationId\":\"WEBSITE\"

			}     
			");
		$token = $this->session->userdata('token');
		$headers = array();
		$headers[] = 'Authorization: Bearer '.$token.'';
		$headers[] = 'Content-Type: application/json';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);
		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}
		curl_close($ch);
		$response2 = json_decode($result);

		if ($response2->statusCode == 1) {
			$this->updateTransactionStatus($response2->data[0]->_id, $response2->data[0]->invoiceNo, $transactionId);
		}

		echo json_encode($response2);
	}

	
	public function contact_us(){
		$data['page'] = 'CONTACT-US';
		$data['title'] = 'CONTACT-US';
		$this->load->view('contact_us',$data);
	}


	public function submitContactForm(){


		// print_r($this->input->post());

		$phone = $this->input->post('phone');

		$new_phone = str_replace('-', '', $phone);

		$fname = $this->input->post('fname');
		$lname = $this->input->post('lname');
		$email = $this->input->post('email');
		$regardingTypes = @$this->input->post('regardingTypes');
		$state = $this->input->post('state');
		$city = $this->input->post('city');
		$zipcode = $this->input->post('zipcode');
		$address = $this->input->post('address');
		$message = $this->input->post('message');


		$captcha_response = trim($this->input->post('g-recaptcha-response'));

		if($captcha_response != ''){

			$ch = curl_init();
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
			curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'].sendContactEmail()['url']);


			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, "{        
				\"firstName\":\"".$fname."\",        
				\"lastName\": \"".$lname."\",        
				\"phone\": \"".$new_phone."\",        
				\"email\": \"".$email."\",        
				\"regardingTypes\":\"".$regardingTypes."\",        
				\"address\":\"".$address."\",        
				\"state\":\"".$state."\",        
				\"city\":\"".$city."\",        
				\"zipcode\":\"".$zipcode."\",        
				\"message\":\"".$message."\",        
				\"clientID\":\"".ApiBaseUrl()['clientID']."\"      
			}");

			$headers = array();
			$headers[] = 'Content-Type: application/json';
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

			$result = curl_exec($ch);
			$response = json_decode($result);

			if (curl_errno($ch)) {
				echo 'Error:' . curl_error($ch);
			}
			curl_close($ch);


			if (@$response->statusCode == 1) {
				$this->session->set_flashdata('success','We will contact you as soon as possible.');
				redirect(base_url('contact-us'),'refresh');
			}else{
				$this->session->set_flashdata('failure','Something went wrong!');
				redirect(base_url('contact-us'),'refresh');
			}
		}else{
			$this->session->set_flashdata('failure','Captcha Validation Failed');
			redirect(base_url('contact-us'),'refresh');
		}

	}

	public function Logout(){
		$this->session->sess_destroy();
		$this->session->unset_userdata('logged_in');
		redirect(base_url());
	}



		// *************************++++++++++++++++++++****************************

	public function AddServicetoSession()
	{


		if($this->input->post('id'))
		{	
			$data = $this->input->post();

			$array = array();
			foreach ($this->input->post('id') as $key => $value) {

				$array[] = array(
					'_id' => $data['id'][$key],
					'serviceName' => $data['serviceName'][$key],

					// 'serviceCategory' => $data['serviceCategory'][$key],
					// 'serviceType' => $data['serviceType'][$key],

					'serviceAmount' => $data['serviceAmount'][$key],
					'startDate' => $data['startDate'][$key],


					'qty' => $data['qty'][$key],

					'time' => $data['startTime'][$key],
					// 'day' => $data['day'][$key],

					// 'serviceAddress' => $data['serviceAddress'][$key],

				);
			}

			$newArray = array(
				'totalPrice' => sprintf("%.2f", $this->input->post('totalPrice')),
				'itemList' => $array,
			);

			$this->session->set_userdata('service_cart', $newArray);
		}


		print_r($newArray);

		$response = array('status' => '1', 'message' => "Success");
		echo json_encode($response);


	}


	public function SubscribeNewsletter(){

		// print_r($this->session->userdata());

		if ($this->session->userdata('logged_in') == 1) {

			$ch = curl_init();
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

			curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'].SubscribeNewsletter()['url']);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, "{
				\"dataJson\": {
					\"MemberId\": \"".$this->session->userdata('id')."\",
					\"Email\": \"".base64_decode($this->session->userdata('email'))."\",
					\"DOB\": \"\",
					\"Name\": \"".$this->session->userdata('refDataName')."\",
					\"Mobile\": \"".$this->session->userdata('phone')."\",
					\"City\": \"\",
					\"State\": \"\",
					\"Nakshatram\": \"\",
					\"Gothram\": \"\",
					\"ZipCode\": \"\",
					\"SpouseName\": \"\",
					\"ChildrenDetails\": \"\",
					\"recCreDate\": \"\",
					\"menberType\": \"".$this->session->userdata('memberTypes')."\"
					},
					\"clientId\": \"".ApiBaseUrl()['clientID']."\"
				}");

			$headers = array();
			$headers[] = 'Content-Type: application/json';
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

			$result = curl_exec($ch);
			$response = json_decode($result);
			if (curl_errno($ch)) {
				echo 'Error:' . curl_error($ch);
			}
			curl_close($ch);

			// print_r($response);

			if (isset($response)) {
				if ($response->statusCode == 1) {
					echo json_encode('Yo have successfully subscribed our newsletter.');
				}elseif($response->statusCode == -1){
					echo json_encode('You are already subscribed our newsletter!');
				}
			}
			else{
				echo 	'Something went wrong! Please contact to Administration or Admin.';
			}

		}else{
			redirect(base_url());
		}


	}




	public function getServiceAvailability(){

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

		curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'].getServiceAvailability()['url']);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, "{
			\"clientId\": \"".ApiBaseUrl()['clientID']."\",
			\"aspectType\": \"serviceBooking\",
			\"ServiceSetup\": \"Vadamala Pooja (108 Vadas)\",
			\"startDate\": \"2023-02-01\",
			\"endDate\": \"2023-02-31\",
			\"serviceTypes\": \"VADAMALA\"
		}");

		$headers = array();
		$headers[] = 'Content-Type: application/json';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);


		$response = json_decode($result);
		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}
		curl_close($ch);


		print_r($response);
	}



	public function GetCity()
	{
		$stateName = $this->input->post('stateCode');


		$CI = & get_instance();
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

		curl_setopt($ch, CURLOPT_URL, ApiBaseUrl()['url'].filterAPI()['url']);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"componentConfig\":    {      
			\"moduleName\": \"Master Data Management\",      
			\"productID\":\"".ApiBaseUrl()['productID']."\",      
			\"clientID\": \"".ApiBaseUrl()['clientID']."\",      
			\"aspectType\":\"cityTypes\",      
			\"query\": {        \"aspectType\": \"cityTypes\",   \"refDataCode\" : \"".$stateName."\"   },    
			\"skip\": 0,      
			\"next\": 700    }    }");

		$headers = array();

		$headers[] = 'Content-Type: application/json';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);

		$response = json_decode($result);

		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}
		curl_close($ch);

		$option = '<option value="" selected disabled>Select City</option>';


		$keys = array_column($response->data, 'refDataName'); 
		array_multisort($keys, SORT_ASC, $response->data);

		foreach($response->data as $item){

			$option .= '<option value="'.$item->refDataName.'">'.$item->refDataName.'</option>';
		}

		echo $option;
	}



	public function GetPriestAvailibility()
	{
		$serviceDate = $this->input->post('serviceDate');
		$targetTime = $this->input->post('serviceTime');

		$result = '';
		if (!empty($serviceDate) && !empty($targetTime)) {
			$result = GetPriestAvailibility($serviceDate, $targetTime);
		}
		$PriestData = $result->data;
		$userDetails = getUserDetails()->data[0];

		$options = '';
		$options .= '<option value=" " selected disabled>Select Preferred Priest</option>';
		if (!empty($PriestData)) {
			foreach ($PriestData as $item) {
				if ($item->availability == 'Available') {
					$options .= '<option value="' . $item->refDataName . '" email="' . base64_decode($item->email) . '" phone="' . base64_decode($item->phone) . '" priestID="' . $item->_id . '">' . $item->refDataName . '</option>';
				}
			}
		} else {
			$options .= '<option value="" selected disabled>Priest Not Available.</option>';
		}

		$options .= '<option value="Any Priest" email="" phone="" priestId="0">Any Priest</option>';
		echo $options;
	}
	
}
