<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class MY_Controller extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

        // Load the library here
		$this->load->library('IP2Location_lib');
		// echo $ip = $_SERVER['REMOTE_ADDR'];
		$ip = $this->input->ip_address();
		$ipl = new IP2Location_lib();
        // BIN Database
		$countryCode = $ipl->getCountryCode($ip);
		$restrictedCountries = array(
										'CN', // China
										'HK', // Hong Kong
										'TH', // Thailand
										'ID', // Indonesia
										'PH', // Philippines
										'BD', // Bangladesh
										'SA', // Saudi Arabia
										'AE', // United Arab Emirates
										'QA', // Qatar
										'KW', // Kuwait
										'OM', // Oman
										'BH', // Bahrain
										'RU', // Russia
										'PL', // Poland
										'RO', // Romania
										'BG', // Bulgaria
										'HU', // Hungary
										'CZ', // Czech Republic
										'SK', // Slovakia	
										'AF', // Afghanistan
									    'BD', // Bangladesh
									    'BT', // Bhutan
									    'MM', // Myanmar (Burma)
									    'CN', // China
									    'NP', // Nepal
									    'PK', // Pakistan
									    'LK', // Sri Lanka				    
									);
		
		if (in_array($countryCode, $restrictedCountries)) {
			echo '<html>
			<head>
			<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
			<title>Access Denied</title>
			<style>
			.container {
				text-align: center;
				margin-top: 150px;
			}

			.icon {
				font-size: 100px;
				color: red;
			}

			.message {
				font-size: 24px;
				margin-top: 20px;
			}
			</style>
			</head>
			<body>
			<div class="container">
			<div class="icon">
			<i class="fa fa-lock"></i>
			</div>
			<div class="message">
			Sorry, you can not access this site in your country due to restrictions.
			</div>
			<div class="reason">
			Reason: Country restrictions
			</div>
			</div>
			</body>
			</html>';
			die();
		}
	}

}
